/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.block;

import cech12.solarcooker.tileentity.AbstractSolarCookerBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractSolarCookerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SUNLIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty BURNING = BlockStateProperties.f_61431_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    protected AbstractSolarCookerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUNLIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BURNING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.interactWith(worldIn, pos, player);
        return InteractionResult.CONSUME;
    }

    protected abstract void interactWith(Level var1, BlockPos var2, Player var3);

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof AbstractSolarCookerBlockEntity) {
            ((AbstractSolarCookerBlockEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof AbstractSolarCookerBlockEntity) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((AbstractSolarCookerBlockEntity)tileentity));
                ((AbstractSolarCookerBlockEntity)tileentity).getRecipesToAwardAndPopExperience(worldIn, Vec3.m_82528_((Vec3i)pos));
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Deprecated
    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@Nonnull BlockState blockState, Level worldIn, @Nonnull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SUNLIT, BURNING});
    }
}

